/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.StealthGoal;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityGrue
extends TameableCreatureEntity
implements IMob {
    private int teleportTime = 60;

    public EntityGrue(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.spawnsInWater = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (EntityAIBase)new StealthGoal(this).setStealthTime(20).setStealthAttack(true).setStealthMove(true));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(true));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.teleportTime-- <= 0) {
            this.teleportTime = 60 + this.func_70681_au().nextInt(40);
            BlockPos teleportPosition = this.getFacingPosition((Entity)this.func_70638_az(), (double)(-this.func_70638_az().field_70130_N) - 1.0, 0.0);
            if (this.canTeleportTo(teleportPosition)) {
                this.playJumpSound();
                this.func_70107_b(teleportPosition.func_177958_n(), teleportPosition.func_177956_o(), teleportPosition.func_177952_p());
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean canTeleportTo(BlockPos pos) {
        for (int y = 0; y <= 1; ++y) {
            IBlockState blockState = this.func_130014_f_().func_180495_p(pos.func_177982_a(0, y, 0));
            if (!blockState.func_185915_l()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canStealth() {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        return this.testLightLevel() <= 0;
    }

    @Override
    public void startStealth() {
        if (this.func_130014_f_().field_72995_K) {
            EnumParticleTypes particle = EnumParticleTypes.SPELL_WITCH;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            for (int i = 0; i < 100; ++i) {
                this.func_130014_f_().func_175688_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
        super.startStealth();
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if (this.isRareVariant() && target instanceof EntityLivingBase) {
            EntityLivingBase targetLiving = (EntityLivingBase)target;
            ArrayList<Potion> goodEffects = new ArrayList<Potion>();
            for (PotionEffect effectInstance : targetLiving.func_70651_bq()) {
                if (!ObjectLists.inEffectList("buffs", effectInstance.func_188419_a())) continue;
                goodEffects.add(effectInstance.func_188419_a());
            }
            if (goodEffects.size() > 0) {
                if (goodEffects.size() > 1) {
                    targetLiving.func_184589_d((Potion)goodEffects.get(this.func_70681_au().nextInt(goodEffects.size())));
                } else {
                    targetLiving.func_184589_d((Potion)goodEffects.get(0));
                }
                float leeching = Math.max(1.0f, this.getAttackDamage(damageScale) / 2.0f);
                this.func_70691_i(leeching);
            }
        }
        return true;
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return this.creatureInfo.bagSize;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean daylightBurns() {
        return false;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public ResourceLocation getTexture(String suffix) {
        if (!"Shadow Clown".equals(this.func_95999_t())) {
            return super.getTexture(suffix);
        }
        String textureName = this.getTextureName() + "_shadowclown";
        if (!"".equals(suffix)) {
            textureName = textureName + "_" + suffix;
        }
        if (AssetManager.getTexture(textureName) == null) {
            AssetManager.addTexture(textureName, this.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }
}

